// By EVOLVED
// www.evolved-software.com

#define Distortion 1
#define FXAA 1
#define DOF 1
#define MotionBlur 1
#define LightScattering 1

//--------------
// tweaks
//--------------
   float2 ViewSize0;
   float2 ViewSize1;
   float2 ViewSize2;
   float2 ViewSize3;
   float2 ViewSize4;
   float Distort=0.05;
   float MiddleGray=0.14;
   float4 Brightness={1.1,1.1,1.1,1.0};
   float CoreBrightness=0.14;
   float GlowBrightness=0.14;
   float HazeBrightness=0.14;
   float2 DofMultiplier={1.0,1.0};
   float DofMinRange=100000.0;
   float Contrast=1.0;
   float Sharpen=0.1;
   float ColorVibrance=0.25;
   float GrayScale=0.0;
   float2 FilmGrain;
   float VignetteMin=0.9;
   float VignetteMax=0.5;
   float4 VignetteColor={0.0,0.0,0.0,0.5};
   float3 LightScatteringColor={1.0,1.0,1.0};

//--------------
// Textures
//--------------
   texture RenderTexture <string Name = " ";>;
   sampler RenderSampler=sampler_state 
      {
	Texture=<RenderTexture>;
      	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };
   texture DistortionTexture <string Name = " ";>;
   sampler DistortionSampler=sampler_state 
      {
	Texture=<DistortionTexture>;
      	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };
   texture MotionBlurTexture <string Name = " ";>;
   sampler MotionBlurSampler=sampler_state 
      {
	Texture=<MotionBlurTexture>;
     	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };
   texture DownFilterTexture <string Name = " ";>;
   sampler DownFilterSampler=sampler_state 
      {
	Texture=<DownFilterTexture>;
     	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };
   texture CoreTexture <string Name = " ";>;
   sampler CoreSampler=sampler_state 
      {
	Texture=<CoreTexture>;
     	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };
   texture GlowTexture <string Name = " ";>;
   sampler GlowSampler=sampler_state 
      {
	Texture=<GlowTexture>;
     	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };
   texture HazeTexture <string Name = " ";>;
   sampler HazeSampler=sampler_state 
      {
	Texture=<HazeTexture>;
     	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };
   texture AdaptedLumTexture <string Name = " ";>;
   sampler AdaptedLumSampler=sampler_state 
      {
	Texture=<AdaptedLumTexture>;
     	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
 	float4 Tex:TEXCOORD0;
 	float4 Tex1:TEXCOORD1;
 	float4 Tex2:TEXCOORD2;
 	float4 Tex3:TEXCOORD3;
	float4 Tex4:TEXCOORD4;
	float4 Tex5:TEXCOORD5;
	float4 Tex6:TEXCOORD6;
	float4 Tex7:TEXCOORD7;
 	float4 Tex8:COLOR0;
 	float4 Tex9:COLOR1;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=IN.Pos;
 	OUT.Tex=float4(((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize0,0.0,0.0);
 	OUT.Tex1=float4(((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize1,0.0,0.0);
 	OUT.Tex2=float4(((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize2,0.0,0.0);
 	OUT.Tex3=float4(((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize3,0.0,0.0);
	OUT.Tex4=float4(((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize4,0.0,0.0);
	OUT.Tex5=float4(OUT.Tex.xy-ViewSize0.xy*2,0.0,0.0);
	OUT.Tex6=float4(OUT.Tex.xy+ViewSize0.xy*2,0.0,0.0);
	OUT.Tex7=float4(OUT.Tex.xy+float2(ViewSize0.x,-ViewSize0.y)*2,0.0,0.0);
	OUT.Tex8=float4(OUT.Tex.xy+float2(-ViewSize0.x,ViewSize0.y)*2,0.0,0.0);
	OUT.Tex9=float4(OUT.Tex.xy*(0.5/ViewSize0.xy),0.0,0.0);
	return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS(OutPut IN) : COLOR
     {
	float Vignette=1.0-smoothstep(VignetteMin,VignetteMax,length(IN.Tex.xy-0.5));
	#if Distortion == 1
	 float4 DistortUV=tex2Dlod(DistortionSampler,IN.Tex)*2.0-1.0;
	 DistortUV.xy=(DistortUV.xy-0.00392156862)*Distort;
	 //DistortUV *=1.0-saturate(tex2Dlod(DownFilterSampler,IN.Tex1).w-tex2D(DownFilterSampler,IN.Tex1+DistortUV).w);
	 float DistortMask=saturate((abs(DistortUV.x)+abs(DistortUV.y))*250.0);
	 IN.Tex +=DistortUV, IN.Tex1 +=DistortUV;
	 float4 FrameRender=tex2Dlod(RenderSampler,IN.Tex);
	#else
	 float DistortMask=0;
	 float4 FrameRender=tex2Dlod(RenderSampler,IN.Tex);
	#endif
	#if FXAA == 1
  	 float lumaNW=dot(tex2Dlod(RenderSampler,IN.Tex5).xyz,float3(0.299,0.587,0.114));
   	 float lumaNE=dot(tex2Dlod(RenderSampler,IN.Tex7).xyz,float3(0.299,0.587,0.114));
   	 float lumaSW=dot(tex2Dlod(RenderSampler,IN.Tex8).xyz,float3(0.299,0.587,0.114));
   	 float lumaSE=dot(tex2Dlod(RenderSampler,IN.Tex6).xyz,float3(0.299,0.587,0.114));
         float2 dir=float2(-((lumaNW+lumaNE)-(lumaSW+lumaSE)),(lumaNW+lumaSW)-(lumaNE+lumaSE));
   	 float dirReduce=max((lumaNW+lumaNE+lumaSW+lumaSE)*0.03125,0.0078125);
   	 dir *=1.0/(min(abs(dir.x),abs(dir.y))+dirReduce);
   	 dir=min(8.0,max(-8.0,dir))*(ViewSize0.xy*2.0);
   	 float3 rgbA=0.5*(tex2Dlod(RenderSampler,float4(IN.Tex.xy+dir*(1.0/3.0-0.5),0.0,0.0)).xyz+tex2Dlod(RenderSampler,float4(IN.Tex.xy+dir*(2.0/3.0-0.5),0.0,0.0)).xyz);
   	 float3 rgbB=rgbA*0.5+0.25*(tex2Dlod(RenderSampler,float4(IN.Tex.xy+dir*(0.0/3.0-0.5),0.0,0.0)).xyz+tex2Dlod(RenderSampler,float4(IN.Tex.xy+dir*(3.0/3.0-0.5),0.0,0.0)).xyz);
   	 float lumaB=dot(rgbB,float3(0.299,0.587,0.114));
         float lumaM=dot(FrameRender.xyz,float3(0.299,0.587,0.114));
         float lumaMin=min(lumaM,min(min(lumaNW,lumaNE),min(lumaSW,lumaSE)));
         float lumaMax=max(lumaM,max(max(lumaNW,lumaNE),max(lumaSW,lumaSE)));
	 if((lumaB<lumaMin) || (lumaB>lumaMax)) rgbB=rgbA;
	 rgbA=(lumaNW+lumaSE+lumaNE+lumaSW)*0.25;
	 rgbA=rgbB+clamp(dot(rgbB,float3(0.299,0.587,0.114))-rgbA,-Sharpen,Sharpen);
	 FrameRender.xyz=lerp(max(rgbA,0.0),FrameRender.xyz,DistortMask);
	#endif
	float2 AdaptedLum=tex1D(AdaptedLumSampler,0.0);
	#if MotionBlur == 1
	 float4 Motion=tex2Dlod(MotionBlurSampler,IN.Tex1);
	 FrameRender.xyz=lerp(FrameRender.xyz,Motion.xyz,Motion.w);
	#endif
	#if DOF == 1
	 float2 AutoFocus=min(AdaptedLum.yy,DofMinRange)*DofMultiplier;
	 float Focus=saturate((FrameRender.w-AutoFocus.x)/AutoFocus.y);
	 FrameRender.xyz=lerp(FrameRender.xyz,tex2Dlod(DownFilterSampler,IN.Tex1).xyz,saturate(Focus*5));
	#endif
	FrameRender.xyz +=tex2Dlod(CoreSampler,IN.Tex2).xyz*CoreBrightness
                         +tex2Dlod(GlowSampler,IN.Tex3).xyz*GlowBrightness
	                 +tex2Dlod(HazeSampler,IN.Tex4).xyz*HazeBrightness;
	FrameRender.xyz *=MiddleGray/max(AdaptedLum.x,0.001);
    	FrameRender.xyz=(FrameRender.xyz*(2.51*FrameRender.xyz+0.03))/(FrameRender.xyz*(2.43*FrameRender.xyz+0.59)+0.14);
	#if LightScattering == 1
	 FrameRender.xyz +=tex2Dlod(CoreSampler,IN.Tex2).w*LightScatteringColor;
	#endif
	float Lumavg=dot(float3(0.299,0.587,0.114),FrameRender);
	FrameRender.xyz=lerp(FrameRender.xyz,Lumavg,GrayScale);
	float Colorsat=max(FrameRender.x,max(FrameRender.y,FrameRender.z))-min(FrameRender.x,min(FrameRender.y,FrameRender.z));
	FrameRender.xyz=lerp(Lumavg,FrameRender,1.0+(ColorVibrance*(1.0-(sign(ColorVibrance)*Colorsat))));
        FrameRender.xyz +=frac(10000*sin((IN.Tex9.x+IN.Tex9.y*FilmGrain.x)*0.01744444444))*FilmGrain.y;
	FrameRender.xyz=lerp(FrameRender.xyz,VignetteColor.xyz,Vignette*VignetteColor.w);
	FrameRender.xyz=pow(FrameRender.xyz,0.454545);
	return float4(pow(FrameRender.xyz,Contrast)*Brightness.xyz,Brightness.w);
     }

//--------------
// techniques   
//--------------
    technique FinalComposite
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS(); 
 	PixelShader  = compile ps_3_0 PS();
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
	AlphaBlendEnable=true;
	SrcBlend=SRCALPHA;
 	DestBlend=INVSRCALPHA;
      }
      }
